!*DECK DSCAL

SUBROUTINE DSCAL (N, DA, DX, INCX)

!***BEGIN PROLOGUE  DSCAL
!***PURPOSE  Multiply a vector by a constant.
!***LIBRARY   SLATEC (BLAS)
!***CATEGORY  D1A6
!***TYPE      DOUBLE PRECISION (SSCAL-S, DSCAL-D, CSCAL-C)
!***KEYWORDS  BLAS, LINEAR ALGEBRA, SCALE, VECTOR
!***AUTHOR  Lawson, C. L., (JPL)
!           Hanson, R. J., (SNLA)
!           Kincaid, D. R., (U. of Texas)
!           Krogh, F. T., (JPL)
!***DESCRIPTION
!
!                B L A S  Subprogram
!    Description of Parameters
!
!     --Input--
!        N  number of elements in input vector(s)
!       DA  double precision scale factor
!       DX  double precision vector with N elements
!     INCX  storage spacing between elements of DX
!
!     --Output--
!       DX  double precision result (unchanged if N.LE.0)
!
!     Replace double precision DX by double precision DA*DX.
!     For I = 0 to N-1, replace DX(IX+I*INCX) with  DA * DX(IX+I*INCX),
!     where IX = 1 if INCX .GE. 0, else IX = 1+(1-N)*INCX.
!
!***REFERENCES  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T.
!                 Krogh, Basic linear algebra subprograms for Fortran
!                 usage, Algorithm No. 539, Transactions on Mathematical
!                 Software 5, 3 (September 1979), pp. 308-323.
!***ROUTINES CALLED  (NONE)
!***REVISION HISTORY  (YYMMDD)
!   791001  DATE WRITTEN
!   890831  Modified array declarations.  (WRB)
!   890831  REVISION DATE from Version 3.2
!   891214  Prologue converted to Version 4.0 format.  (BAB)
!   900821  Modified to correct problem with a negative increment.
!           (WRB)
!   920501  Reformatted the REFERENCES section.  (WRB)
!***END PROLOGUE  DSCAL

real*8, intent(in) :: DA
real*8, intent(inout), dimension(*) :: DX

integer(4), intent(in) :: n, incx
INTEGER(4) :: I, IX, M, MP1

!***FIRST EXECUTABLE STATEMENT  DSCAL

IF (N .LE. 0) RETURN
IF (INCX .NE. 1) THEN
!     Code for increment not equal to 1.
      IX = 1
      IF (INCX .LT. 0) IX = (-N+1)*INCX + 1
      DO I = 1,N
        DX(IX) = DA*DX(IX)
        IX = IX + INCX
      END DO
ELSE
!     Code for increment equal to 1.
!     Clean-up loop so remaining vector length is a multiple of 5.

      M = MOD(N,5)
      IF (M .NE. 0) THEN
        DO I = 1,M
          DX(I) = DA*DX(I)
        END DO
      IF (N .LT. 5) RETURN
	  END IF

      MP1 = M + 1
      DO I = MP1,N,5
        DX(I) = DA*DX(I)
        DX(I+1) = DA*DX(I+1)
        DX(I+2) = DA*DX(I+2)
        DX(I+3) = DA*DX(I+3)
        DX(I+4) = DA*DX(I+4)
      END DO
END IF

RETURN
END
